
## 📂 1. 파일 기반 포맷

GIS에서 가장 많이 쓰이는 전통적 방식이에요.

* **Shapefile (.shp, .shx, .dbf, …)**

  * 가장 오래된 벡터 포맷.
  * 단일 파일이 아니고 여러 파일 조합.
  * 속성 이름 제한(10자), UTF-8 지원 제한 등 단점 많음.
* **GeoJSON (.geojson, .json)**

  * 웹 서비스용으로 많이 사용.
  * 가볍고 범용성이 좋음, 하지만 대용량에는 비효율적.
* **KML/KMZ (Google Earth)**

  * XML 기반, 스타일 정보 포함 가능.
* **FlatGeobuf (.fgb)**

  * 최신 포맷, 빠른 인덱싱 & 스트리밍 지원.
  * Shapefile/GeoJSON 대체용으로 각광.
* **MBTiles (.mbtiles)**

  * SQLite 기반, 타일 이미지/벡터타일 저장.
  * 오프라인 지도 앱에서 많이 사용.
* **TIFF/GeoTIFF (.tif)**

  * 위성영상, 항공영상 같은 래스터 데이터 저장.
* **Cloud Optimized GeoTIFF (COG)**

  * GeoTIFF 확장판, HTTP Range 기반으로 부분 스트리밍 가능.

---

## 🗄️ 2. 데이터베이스 기반 포맷

동시 사용자 지원, 대용량 관리에 유리해요.

* **PostGIS (PostgreSQL + GIS 확장)**

  * 가장 널리 쓰이는 오픈소스 공간 DB.
  * 복잡한 공간쿼리, 인덱스, 웹서비스 연동에 강력.
* **Oracle Spatial / Locator**

  * Oracle DB의 공간 확장 기능.
* **SQL Server Spatial**

  * Microsoft SQL Server 공간 데이터 타입.
* **SpatiaLite**

  * SQLite 기반, GeoPackage의 전신격.
* **Enterprise Geodatabase (ArcSDE)**

  * Esri의 DBMS 기반 공간 데이터 관리 시스템.

---

## 🚀 3. 특수 목적 포맷

* **LAS/LAZ** → LiDAR 점군 데이터 저장. (LAZ는 압축버전)
* **NetCDF / HDF5** → 시계열 기후, 해양, 대기 과학 데이터.
* **GRIB** → 기상 예보 데이터 표준.
* **GTFS** → 대중교통 노선/시간표 데이터.

---

## 📌 정리

* **벡터 위주**: Shapefile, GeoJSON, GPKG, FlatGeobuf, GDB
* **타일/웹지도**: MBTiles, COG, GeoTIFF
* **대규모 분석/서비스**: PostGIS, Oracle Spatial, Enterprise GDB

---

👉 만약 지금 고민이 "대한민국 항공영상 TIFF를 효율적으로 저장하고 서비스"라면, **GeoTIFF/COG + DB(PostGIS) + Tile Cache(MBTiles)** 조합이 최적일 수 있습니다.

혹시 원하시는 건 **“파일 포맷 종류의 카탈로그”** 같은 큰 그림일까요, 아니면 \*\*현재 상황(항공영상 타일 서비스)**에 맞는 적합한 포맷 추천**을 원하시나요?
